/*!
 * 
 * 4DView Pro library 0.0.0
 * 
 * Copyright(c) 4D SAS.  All rights reserved.
 * 
 * 4D (the "Software") and the corresponding source code remain
 * the exclusive property of 4D and/or its licensors and are protected by national
 * and/or international legislations.
 * 
 * This file is part of the source code of the Software provided under the relevant
 * 4D License Agreement available on http://www.4D.com/license whose compliance
 * constitutes a prerequisite to any use of this file and more generally of the
 * Software and the corresponding source code.
 * 
 */

Utils.addCommand('get-editor-properties', function (property) {
    switch (property) {
        case "options":
            return _spread()[property];
        case "allowUserDragDrop":
        case "allowUserDragFill":
        case "allowUserZoom":
        case "showDragFillSmartTag":
        case "resizeZeroIndicator":
            return _spread().options[property];
        default:
            return false;
    }
});

Utils.addCommand('get-sheet-properties', function (property) {
    let sheet = Utils.spread.getActiveSheet();

    switch (property) {

        case "options":
            return sheet[property];
        case "gridline":
        case "protectionOptions":
            return sheet.options[property];
        case "name":
            return sheet.name();
        case "rowCount":
            return sheet.getRowCount();
        case "colCount":
            return sheet.getColumnCount();
        case "frozenRowCount":
        case "frozenColumnCount":
        case "frozenTrailingRowCount":
        case "frozenTrailingColumnCount":
            return sheet[property];
        case "rowHeaderAutoText":
        case "rowHeaderAutoTextIndex":
        case "rowHeaderVisible":
        case "colHeaderAutoText":
        case "colHeaderAutoTextIndex":
        case "colHeaderVisible":
        case "allowCellOverflow":
        case "frozenlineColor":
        case "isProtected":
            return sheet.options[property];
        default:
            return false;
    }
});